/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tubemodules;

import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.common.block.entity.PressureTubeBlockEntity;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.tubemodules.AbstractTubeModule;
import net.minecraft.core.Direction;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class ChargingModule
extends AbstractTubeModule {
    private BlockEntity neighbourTE = null;

    public ChargingModule(Direction dir, PressureTubeBlockEntity pressureTube) {
        super(dir, pressureTube);
    }

    @Override
    public Item getItem() {
        return (Item)ModItems.CHARGING_MODULE.get();
    }

    @Override
    public void tickServer() {
        super.tickServer();
        if (this.pressureTube.nonNullLevel().f_46443_ || (this.pressureTube.nonNullLevel().m_46467_() & 7L) != 0L) {
            return;
        }
        this.getConnectedInventory().ifPresent(itemHandler -> {
            int airToTransfer = 80 * (this.upgraded ? 10 : 1);
            this.pressureTube.getCapability(PNCCapabilities.AIR_HANDLER_MACHINE_CAPABILITY).ifPresent(airHandler -> {
                for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
                    ItemStack chargedItem = itemHandler.getStackInSlot(slot);
                    if (chargedItem.m_41613_() != 1) continue;
                    chargedItem.getCapability(PNCCapabilities.AIR_HANDLER_ITEM_CAPABILITY).ifPresent(airHandlerItem -> {
                        float itemPressure = airHandlerItem.getPressure();
                        float itemVolume = airHandlerItem.getVolume();
                        float delta = Math.abs(airHandler.getPressure() - itemPressure) / 2.0f;
                        int airInItem = airHandlerItem.getAir();
                        if (itemPressure > airHandler.getPressure() + 0.01f && itemPressure > 0.0f) {
                            int airToMove = Math.min(Math.min(airToTransfer, airInItem), (int)(delta * (float)airHandler.getVolume()));
                            airHandlerItem.addAir(-airToMove / chargedItem.m_41613_());
                            airHandler.addAir(airToMove);
                        } else if (itemPressure < airHandler.getPressure() - 0.01f && itemPressure < airHandlerItem.maxPressure()) {
                            int maxAirInItem = (int)(airHandlerItem.maxPressure() * itemVolume);
                            int airToMove = Math.min(Math.min(airToTransfer, airHandler.getAir()), maxAirInItem - airInItem);
                            airToMove = Math.min((int)(delta * itemVolume), airToMove);
                            airHandlerItem.addAir(airToMove / chargedItem.m_41613_());
                            airHandler.addAir(-airToMove);
                        }
                    });
                }
            });
        });
    }

    private LazyOptional<IItemHandler> getConnectedInventory() {
        if (this.neighbourTE == null || this.neighbourTE.m_58901_()) {
            this.neighbourTE = this.pressureTube.nonNullLevel().m_7702_(this.pressureTube.m_58899_().m_142300_(this.dir));
        }
        return this.neighbourTE == null ? LazyOptional.empty() : this.neighbourTE.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.dir.m_122424_());
    }
}

